import request from '@/utils/request'

// 查询委外作业列表
export function listEntrustWork(query) {
  return request({
    url: '/business/entrustWork/list',
    method: 'get',
    params: query
  })
}

// 查询委外作业详细
export function getEntrustWork(id) {
  return request({
    url: '/business/entrustWork/' + id,
    method: 'get'
  })
}

// 新增委外作业
export function addEntrustWork(data) {
  return request({
    url: '/business/entrustWork',
    method: 'post',
    data: data
  })
}

// 修改委外作业
export function updateEntrustWork(data) {
  return request({
    url: '/business/entrustWork/edit',
    method: 'post',
    data: data
  })
}

// 删除委外作业
export function delEntrustWork(id) {
  return request({
    url: '/business/entrustWork/delete/' + id,
    method: 'post'
  })
}
