import request from '@/utils/request'

// 查询环保管理列表
export function listPROTECTION(query) {
  return request({
    url: '/business/environmental/list',
    method: 'get',
    params: query
  })
}

// 查询环保管理详细
export function getPROTECTION(id) {
  return request({
    url: '/business/environmental/' + id,
    method: 'get'
  })
}

// 新增环保管理
export function addPROTECTION(data) {
  return request({
    url: '/business/environmental',
    method: 'post',
    data: data
  })
}

// 修改环保管理
export function updatePROTECTION(data) {
  return request({
    url: '/business/environmental/edit',
    method: 'post',
    data: data
  })
}

// 删除环保管理
export function delPROTECTION(id) {
  return request({
    url: '/business/environmental/delete/' + id,
    method: 'post'
  })
}
