import request from '@/utils/request'

// 查询演练计划列表
export function listPLAN(query) {
  return request({
    url: '/business/exercisePlan/getList',
    method: 'get',
    params: query
  })
}

// 查询演练计划详细
export function getPLAN(id) {
  return request({
    url: '/business/exercisePlan/' + id,
    method: 'get'
  })
}

// 新增演练计划
export function addPLAN(data) {
  return request({
    url: '/business/exercisePlan',
    method: 'post',
    data: data
  })
}

// 修改演练计划
export function updatePLAN(data) {
  return request({
    url: '/business/exercisePlan/edit',
    method: 'post',
    data: data
  })
}

// 删除演练计划
export function delPLAN(id) {
  return request({
    url: '/business/exercisePlan/delete/' + id,
    method: 'post'
  })
}
