import request from '@/utils/request'

// 查询防火检查列表
export function listINSPECT(query) {
  return request({
    url: '/business/fireInspect/getList',
    method: 'get',
    params: query
  })
}

// 查询防火检查详细
export function getINSPECT(id) {
  return request({
    url: '/business/fireInspect/' + id,
    method: 'get'
  })
}

// 新增防火检查
export function addINSPECT(data) {
  return request({
    url: '/business/fireInspect',
    method: 'post',
    data: data
  })
}

// 修改防火检查
export function updateINSPECT(data) {
  return request({
    url: '/business/fireInspect/edit',
    method: 'post',
    data: data
  })
}

// 删除防火检查
export function delINSPECT(id) {
  return request({
    url: '/business/fireInspect/delete/' + id,
    method: 'post'
  })
}
