import request from '@/utils/request'

// 查询急救箱列表
export function listKIT(query) {
  return request({
    url: '/business/firstAidKit/list',
    method: 'get',
    params: query
  })
}

// 查询急救箱详细
export function getKIT(id) {
  return request({
    url: '/business/firstAidKit/' + id,
    method: 'get'
  })
}

// 新增急救箱
export function addKIT(data) {
  return request({
    url: '/business/firstAidKit',
    method: 'post',
    data: data
  })
}

// 修改急救箱
export function updateKIT(data) {
  return request({
    url: '/business/firstAidKit/edit',
    method: 'post',
    data: data
  })
}

// 删除急救箱
export function delKIT(id) {
  return request({
    url: '/business/firstAidKit/delete/' + id,
    method: 'post'
  })
}
