import request from '@/utils/request'

// 查询四不过处理记录列表
export function listInjuryFourThough(query) {
  return request({
    url: '/business/injuryFourThough/list',
    method: 'get',
    params: query
  })
}

// 查询四不过处理记录详细
export function getInjuryFourThough(id) {
  return request({
    url: '/business/injuryFourThough/' + id,
    method: 'get'
  })
}

// 新增四不过处理记录
export function addInjuryFourThough(data) {
  return request({
    url: '/business/injuryFourThough',
    method: 'post',
    data: data
  })
}

// 修改四不过处理记录
export function updateInjuryFourThough(data) {
  return request({
    url: '/business/injuryFourThough/edit',
    method: 'post',
    data: data
  })
}

// 删除四不过处理记录
export function delInjuryFourThough(id) {
  return request({
    url: '/business/injuryFourThough/delete/' + id,
    method: 'post'
  })
}


// 查询调查报告详细：根据工伤报告主键查询
export function getInjuryFourThoughByBusinessId(businessId) {
  return request({
    url: '/business/injuryFourThough/businessId/' + businessId,
    method: 'get'
  })
}
