import request from '@/utils/request'

// 查询工伤报告列表
export function listREPORT(query) {
  return request({
    url: '/business/injuryReport/list',
    method: 'get',
    params: query
  })
}

// 查询工伤报告详细
export function getREPORT(id) {
  return request({
    url: '/business/injuryReport/' + id,
    method: 'get'
  })
}

// 新增工伤报告
export function addREPORT(data) {
  return request({
    url: '/business/injuryReport',
    method: 'post',
    data: data
  })
}

// 修改工伤报告
export function updateREPORT(data) {
  return request({
    url: '/business/injuryReport/edit',
    method: 'post',
    data: data
  })
}

// 删除工伤报告
export function delREPORT(id) {
  return request({
    url: '/business/injuryReport/delete/' + id,
    method: 'post'
  })
}
