import request from '@/utils/request'

// 查询调查报告列表
export function listInjuryResearch(query) {
  return request({
    url: '/business/injuryResearch/list',
    method: 'get',
    params: query
  })
}

// 查询调查报告详细
export function getInjuryResearch(id) {
  return request({
    url: '/business/injuryResearch/' + id,
    method: 'get'
  })
}

// 新增调查报告
export function addInjuryResearch(data) {
  return request({
    url: '/business/injuryResearch',
    method: 'post',
    data: data
  })
}

// 修改调查报告
export function updateInjuryResearch(data) {
  return request({
    url: '/business/injuryResearch/edit',
    method: 'post',
    data: data
  })
}

// 删除调查报告
export function delInjuryResearch(id) {
  return request({
    url: '/business/injuryResearch/delete/' + id,
    method: 'post'
  })
}

// 查询调查报告详细：根据工伤报告主键查询
export function getInjuryResearchByBusinessId(businessId) {
  return request({
    url: '/business/injuryResearch/businessId/' + businessId,
    method: 'get'
  })
}
