import request from '@/utils/request'

// 查询调查报告记录列表
export function listInjuryResearchRecord(query) {
  return request({
    url: '/business/injuryResearchRecord/list',
    method: 'get',
    params: query
  })
}

// 查询调查报告记录详细
export function getInjuryResearchRecord(id) {
  return request({
    url: '/business/injuryResearchRecord/' + id,
    method: 'get'
  })
}

// 新增调查报告记录
export function addInjuryResearchRecord(data) {
  return request({
    url: '/business/injuryResearchRecord',
    method: 'post',
    data: data
  })
}

// 修改调查报告记录
export function updateInjuryResearchRecord(data) {
  return request({
    url: '/business/injuryResearchRecord/edit',
    method: 'post',
    data: data
  })
}

// 删除调查报告记录
export function delInjuryResearchRecord(id) {
  return request({
    url: '/business/injuryResearchRecord/delete/' + id,
    method: 'post'
  })
}
