import request from '@/utils/request'

// 查询工伤报告反馈结果列表
export function listInjuryResult(query) {
  return request({
    url: '/business/injuryResult/list',
    method: 'get',
    params: query
  })
}

// 查询工伤报告反馈结果详细
export function getInjuryResult(id) {
  return request({
    url: '/business/injuryResult/' + id,
    method: 'get'
  })
}

// 新增工伤报告反馈结果
export function addInjuryResult(data) {
  return request({
    url: '/business/injuryResult',
    method: 'post',
    data: data
  })
}

// 修改工伤报告反馈结果
export function updateInjuryResult(data) {
  return request({
    url: '/business/injuryResult/edit',
    method: 'post',
    data: data
  })
}

// 删除工伤报告反馈结果
export function delInjuryResult(id) {
  return request({
    url: '/business/injuryResult/delete/' + id,
    method: 'post'
  })
}

// 查询调查报告详细：根据工伤报告主键查询
export function getInjuryResultByBusinessId(businessId) {
  return request({
    url: '/business/injuryResult/businessId/' + businessId,
    method: 'get'
  })
}
