import request from '@/utils/request'

// 查询事故回顾培训记录列表
export function listInjuryTrailRecord(query) {
  return request({
    url: '/business/injuryTrailRecord/list',
    method: 'get',
    params: query
  })
}

// 查询事故回顾培训记录详细
export function getInjuryTrailRecord(id) {
  return request({
    url: '/business/injuryTrailRecord/' + id,
    method: 'get'
  })
}

// 新增事故回顾培训记录
export function addInjuryTrailRecord(data) {
  return request({
    url: '/business/injuryTrailRecord',
    method: 'post',
    data: data
  })
}

// 修改事故回顾培训记录
export function updateInjuryTrailRecord(data) {
  return request({
    url: '/business/injuryTrailRecord/edit',
    method: 'post',
    data: data
  })
}

// 删除事故回顾培训记录
export function delInjuryTrailRecord(id) {
  return request({
    url: '/business/injuryTrailRecord/delete',
    method: 'post',
    data: id
  })
}

// 查询事故培训记录详细：根据工伤报告主键查询
export function getInjuryTrailRecordByBusinessId(businessId) {
  return request({
    url: '/business/injuryTrailRecord/businessId/' + businessId,
    method: 'get'
  })
}