import request from '@/utils/request'

// 查询劳保领用台账列表
export function listLaborUseLedger(query) {
  return request({
    url: '/business/laborUseLedger/list',
    method: 'get',
    params: query
  })
}

// 查询劳保领用台账详细
export function getLaborUseLedger(id) {
  return request({
    url: '/business/laborUseLedger/' + id,
    method: 'get'
  })
}

// 新增劳保领用台账
export function addLaborUseLedger(data) {
  return request({
    url: '/business/laborUseLedger',
    method: 'post',
    data: data
  })
}

// 修改劳保领用台账
export function updateLaborUseLedger(data) {
  return request({
    url: '/business/laborUseLedger/edit',
    method: 'post',
    data: data
  })
}

// 删除劳保领用台账
export function delLaborUseLedger(id) {
  return request({
    url: '/business/laborUseLedger/delete' + id,
    method: 'post'
  })
}
