import request from '@/utils/request'

// 查询事务管理任务执行复查列表
export function listManageTaskExecute(query) {
  return request({
    url: '/business/manageTaskExecute/list',
    method: 'get',
    params: query
  })
}

// 查询事务管理任务执行复查详细
export function getManageTaskExecute(id) {
  return request({
    url: '/business/manageTaskExecute/' + id,
    method: 'get'
  })
}

// 新增事务管理任务执行复查
export function addManageTaskExecute(data) {
  return request({
    url: '/business/manageTaskExecute',
    method: 'post',
    data: data
  })
}

// 修改事务管理任务执行复查
export function updateManageTaskExecute(data) {
  return request({
    url: '/business/manageTaskExecute/edit',
    method: 'post',
    data: data
  })
}

// 删除事务管理任务执行复查
export function delManageTaskExecute(id) {
  return request({
    url: '/business/manageTaskExecute/delete/' + id,
    method: 'post'
  })
}

// 任务执行
export function handleManageTaskExecute(data) {
  return request({
    url: '/business/manageTaskExecute/handle',
    method: 'post',
    data: data
  })
}
// 任务复查
export function reviewManageTaskExecute(data) {
  return request({
    url: '/business/manageTaskExecute/review',
    method: 'post',
    data: data
  })
}

// 删除事务管理任务执行复查
export function batchListManageTaskExecute(id) {
  return request({
    url: '/business/manageTaskExecute/batchList/' + id,
    method: 'post'
  })
}

// 任务复查
export function batchReviewManageTaskExecute(data) {
  return request({
    url: '/business/manageTaskExecute/batchReview',
    method: 'post',
    data: data
  })
}
