import request from '@/utils/request'

// 查询事务管理任务计划列表
export function listManageTaskPlan(query) {
  return request({
    url: '/business/manageTaskPlan/list',
    method: 'get',
    params: query
  })
}

// 查询事务管理任务计划详细
export function getManageTaskPlan(id) {
  return request({
    url: '/business/manageTaskPlan/' + id,
    method: 'get'
  })
}

// 新增事务管理任务计划
export function addManageTaskPlan(data) {
  return request({
    url: '/business/manageTaskPlan',
    method: 'post',
    data: data
  })
}

// 修改事务管理任务计划
export function updateManageTaskPlan(data) {
  return request({
    url: '/business/manageTaskPlan/edit',
    method: 'post',
    data: data
  })
}

// 删除事务管理任务计划
export function delManageTaskPlan(id) {
  return request({
    url: '/business/manageTaskPlan/delete/' + id,
    method: 'post'
  })
}

// 修改事务管理任务计划
export function updateManageTaskPlanStatus(data) {
  return request({
    url: '/business/manageTaskPlan/updateStatus',
    method: 'post',
    data: data
  })
}
