import request from '@/utils/request'

// 查询事务管理任务执行转派历史列表
export function listManageTaskTransfer(query) {
  return request({
    url: '/business/manageTaskTransfer/list',
    method: 'get',
    params: query
  })
}

// 查询事务管理任务执行转派历史详细
export function getManageTaskTransfer(id) {
  return request({
    url: '/business/manageTaskTransfer/' + id,
    method: 'get'
  })
}

// 新增事务管理任务执行转派历史
export function addManageTaskTransfer(data) {
  return request({
    url: '/business/manageTaskTransfer',
    method: 'post',
    data: data
  })
}

// 修改事务管理任务执行转派历史
export function updateManageTaskTransfer(data) {
  return request({
    url: '/business/manageTaskTransfer/edit',
    method: 'post',
    data: data
  })
}

// 删除事务管理任务执行转派历史
export function delManageTaskTransfer(id) {
  return request({
    url: '/business/manageTaskTransfer/delete/' + id,
    method: 'post'
  })
}
