import request from '@/utils/request'

// 查询事务管理工单历史纪录列表
export function listManageWorkHis(query) {
  return request({
    url: '/business/manageWorkHis/list',
    method: 'get',
    params: query
  })
}

// 查询事务管理工单历史纪录详细
export function getManageWorkHis(id) {
  return request({
    url: '/business/manageWorkHis/' + id,
    method: 'get'
  })
}

// 新增事务管理工单历史纪录
export function addManageWorkHis(data) {
  return request({
    url: '/business/manageWorkHis',
    method: 'post',
    data: data
  })
}

// 修改事务管理工单历史纪录
export function updateManageWorkHis(data) {
  return request({
    url: '/business/manageWorkHis/edit',
    method: 'post',
    data: data
  })
}

// 删除事务管理工单历史纪录
export function delManageWorkHis(id) {
  return request({
    url: '/business/manageWorkHis/delete/' + id,
    method: 'post'
  })
}
