import request from '@/utils/request'

// 查询事务管理工单历史纪录列表
export function listManageWorkNotice(query) {
  return request({
    url: '/business/manageWorkNotice/list',
    method: 'get',
    params: query
  })
}

// 查询事务管理工单历史纪录详细
export function getManageWorkNotice(id) {
  return request({
    url: '/business/manageWorkNotice/' + id,
    method: 'get'
  })
}

// 新增事务管理工单历史纪录
export function addManageWorkNotice(data) {
  return request({
    url: '/business/manageWorkNotice',
    method: 'post',
    data: data
  })
}

// 修改事务管理工单历史纪录
export function updateManageWorkNotice(data) {
  return request({
    url: '/business/manageWorkNotice/edit',
    method: 'post',
    data: data
  })
}

// 删除事务管理工单历史纪录
export function delManageWorkNotice(id) {
  return request({
    url: '/business/manageWorkNotice/delete/' + id,
    method: 'post'
  })
}
