import request from '@/utils/request'

// 查询事务管理工单管理列表
export function listManageWorkOrder(query) {
  return request({
    url: '/business/manageWorkOrder/list',
    method: 'get',
    params: query
  })
}

// 查询事务管理工单管理详细
export function getManageWorkOrder(id) {
  return request({
    url: '/business/manageWorkOrder/' + id,
    method: 'get'
  })
}

// 新增事务管理工单管理
export function addManageWorkOrder(data) {
  return request({
    url: '/business/manageWorkOrder',
    method: 'post',
    data: data
  })
}

// 修改事务管理工单管理
export function updateManageWorkOrder(data) {
  return request({
    url: '/business/manageWorkOrder/edit',
    method: 'post',
    data: data
  })
}

// 删除事务管理工单管理
export function delManageWorkOrder(id) {
  return request({
    url: '/business/manageWorkOrder/delete/' + id,
    method: 'post'
  })
}

// 催办
export function updateOnUrgentManageWorkOrder(data) {
  return request({
    url: '/business/manageWorkOrder/onUrgent',
    method: 'post',
    data: data
  })
}

// 工单确认，工单处理
export function handleConfirmManageWorkOrder(data) {
  return request({
    url: '/business/manageWorkOrder/handleConfirm',
    method: 'post',
    data: data
  })
}

// 通知确认人(创建人)需要转派给其他人员
export function handleNoticeTransfer(data) {
  return request({
    url: '/business/manageWorkOrder/noticeTransfer',
    method: 'post',
    data: data
  })
}

// 转派
export function handleTransfer(data) {
  return request({
    url: '/business/manageWorkOrder/transfer',
    method: 'post',
    data: data
  })
}
