import request from '@/utils/request'

// 查询职业病危害报告列表
export function listREPORT(query) {
  return request({
    url: '/business/odReport/getList',
    method: 'get',
    params: query
  })
}

// 查询职业病危害报告详细
export function getREPORT(id) {
  return request({
    url: '/business/odReport/' + id,
    method: 'get'
  })
}

// 新增职业病危害报告
export function addREPORT(data) {
  return request({
    url: '/business/odReport',
    method: 'post',
    data: data
  })
}

// 修改职业病危害报告
export function updateREPORT(data) {
  return request({
    url: '/business/odReport/edit',
    method: 'post',
    data: data
  })
}

// 删除职业病危害报告
export function delREPORT(id) {
  return request({
    url: '/business/odReport/delete/' + id,
    method: 'post'
  })
}
