import request from '@/utils/request'

// 查询体检计划列表
export function listPhysicalPlan(query) {
  return request({
    url: '/business/physicalPlan/getList',
    method: 'get',
    params: query
  })
}

// 查询体检计划详细
export function getPhysicalPlan(id) {
  return request({
    url: '/business/physicalPlan/' + id,
    method: 'get'
  })
}

// 新增体检计划
export function addPhysicalPlan(data) {
  return request({
    url: '/business/physicalPlan',
    method: 'post',
    data: data
  })
}

// 修改体检计划
export function updatePhysicalPlan(data) {
  return request({
    url: '/business/physicalPlan/edit',
    method: 'post',
    data: data
  })
}

// 删除体检计划
export function delPhysicalPlan(id) {
  return request({
    url: '/business/physicalPlan/delete/' + id,
    method: 'post'
  })
}
