import request from '@/utils/request'

// 查询体检报告列表
export function listPhysicalReport(query) {
  return request({
    url: '/business/physicalReport/getList',
    method: 'get',
    params: query
  })
}

// 查询体检报告详细
export function getPhysicalReport(id) {
  return request({
    url: '/business/physicalReport/' + id,
    method: 'get'
  })
}

// 新增体检报告
export function addPhysicalReport(data) {
  return request({
    url: '/business/physicalReport',
    method: 'post',
    data: data
  })
}

// 修改体检报告
export function updatePhysicalReport(data) {
  return request({
    url: '/business/physicalReport/edit',
    method: 'post',
    data: data
  })
}

// 删除体检报告
export function delPhysicalReport(id) {
  return request({
    url: '/business/physicalReport/delete/' + id,
    method: 'post'
  })
}
