import request from '@/utils/request'

// 查询体检结果列表
export function listPhysicalResult(query) {
  return request({
    url: '/business/physicalResult/list',
    method: 'get',
    params: query
  })
}

// 查询体检结果详细
export function getPhysicalResult(id) {
  return request({
    url: '/business/physicalResult/' + id,
    method: 'get'
  })
}

// 新增体检结果
export function addPhysicalResult(data) {
  return request({
    url: '/business/physicalResult',
    method: 'post',
    data: data
  })
}

// 修改体检结果
export function updatePhysicalResult(data) {
  return request({
    url: '/business/physicalResult/edit',
    method: 'post',
    data: data
  })
}

// 删除体检结果
export function delPhysicalResult(id) {
  return request({
    url: '/business/physicalResult/delete/' + id,
    method: 'post'
  })
}
