import request from '@/utils/request'

// 查询政策公告列表
export function listPolicyNotice(query) {
  return request({
    url: '/business/policyNotice/list',
    method: 'get',
    params: query
  })
}

// 查询政策公告详细
export function getPolicyNotice(id) {
  return request({
    url: '/business/policyNotice/' + id,
    method: 'get'
  })
}

// 新增政策公告
export function addPolicyNotice(data) {
  return request({
    url: '/business/policyNotice',
    method: 'post',
    data: data
  })
}

// 修改政策公告
export function updatePolicyNotice(data) {
  return request({
    url: '/business/policyNotice/edit',
    method: 'post',
    data: data
  })
}

// 删除政策公告
export function delPolicyNotice(id) {
  return request({
    url: '/business/policyNotice/delete/' + id,
    method: 'post'
  })
}
