import request from '@/utils/request'

// 查询岗位检查列表
export function listINSPECT(query) {
  return request({
    url: '/business/postInspect/getList',
    method: 'get',
    params: query
  })
}

// 查询岗位检查详细
export function getINSPECT(id) {
  return request({
    url: '/business/postInspect/' + id,
    method: 'get'
  })
}

// 新增岗位检查
export function addINSPECT(data) {
  return request({
    url: '/business/postInspect',
    method: 'post',
    data: data
  })
}

// 修改岗位检查
export function updateINSPECT(data) {
  return request({
    url: '/business/postInspect/edit',
    method: 'post',
    data: data
  })
}

// 删除岗位检查
export function delINSPECT(id) {
  return request({
    url: '/business/postInspect/delete/' + id,
    method: 'post'
  })
}
