import request from '@/utils/request'

// 查询安全检查隐患列表
export function listSecurityInspectDanger(query) {
  return request({
    url: '/business/securityInspectDanger/list',
    method: 'get',
    params: query
  })
}

// 查询安全检查隐患详细
export function getSecurityInspectDanger(id) {
  return request({
    url: '/business/securityInspectDanger/' + id,
    method: 'get'
  })
}

// 新增安全检查隐患
export function addSecurityInspectDanger(data) {
  return request({
    url: '/business/securityInspectDanger',
    method: 'post',
    data: data
  })
}

// 修改安全检查隐患
export function updateSecurityInspectDanger(data) {
  return request({
    url: '/business/securityInspectDanger/edit',
    method: 'post',
    data: data
  })
}

// 修改安全检查隐患
export function updateSecurityInspectDangerMain(data) {
  return request({
    url: '/business/securityInspectDanger/editMain',
    method: 'post',
    data: data
  })
}

// 删除安全检查隐患
export function delSecurityInspectDanger(id) {
  return request({
    url: '/business/securityInspectDanger/delete/' + id,
    method: 'post',
    data: id
  })
}


// 整改落实情况
export function updateFixSecurityInspectDanger(data) {
  return request({
    url: '/business/securityInspectDanger/fixEdit',
    method: 'post',
    data: data
  })
}

// 验收情况
export function updateAcceptSecurityInspectDanger(data) {
  return request({
    url: '/business/securityInspectDanger/acceptEdit',
    method: 'post',
    data: data
  })
}

// 转派
export function updateTransferSecurityInspectDanger(data) {
  return request({
    url: '/business/securityInspectDanger/transferEdit',
    method: 'post',
    data: data
  })
}

// 查询安全检查隐患详细
export function getReportAndDanger(id) {
  return request({
    url: '/business/securityInspectDanger/reportAndDanger/' + id,
    method: 'get'
  })
}

// 转派
export function updateOnUrgentSecurityInspectDanger(data) {
  return request({
    url: '/business/securityInspectDanger/onUrgent',
    method: 'post',
    data: data
  })
}

