import request from '@/utils/request'

// 查询安全检查隐患历史列表
export function listSecurityInspectDangerHis(query) {
  return request({
    url: '/business/securityInspectDangerHis/list',
    method: 'get',
    params: query
  })
}

// 查询安全检查隐患历史详细
export function getSecurityInspectDangerHis(id) {
  return request({
    url: '/business/securityInspectDangerHis/' + id,
    method: 'get'
  })
}

// 新增安全检查隐患历史
export function addSecurityInspectDangerHis(data) {
  return request({
    url: '/business/securityInspectDangerHis',
    method: 'post',
    data: data
  })
}

// 修改安全检查隐患历史
export function updateSecurityInspectDangerHis(data) {
  return request({
    url: '/business/securityInspectDangerHis/edit',
    method: 'post',
    data: data
  })
}

// 删除安全检查隐患历史
export function delSecurityInspectDangerHis(id) {
  return request({
    url: '/business/securityInspectDangerHis/delete/' + id,
    method: 'post'
  })
}
