import request from '@/utils/request'

// 查询安全检查整改列表
export function listSecurityInspectRectify(query) {
  return request({
    url: '/business/securityInspectRectify/list',
    method: 'get',
    params: query
  })
}

// 查询安全检查整改详细
export function getSecurityInspectRectify(id) {
  return request({
    url: '/business/securityInspectRectify/' + id,
    method: 'get'
  })
}

// 新增安全检查整改
export function addSecurityInspectRectify(data) {
  return request({
    url: '/business/securityInspectRectify',
    method: 'post',
    data: data
  })
}

// 修改安全检查整改
export function updateSecurityInspectRectify(data) {
  return request({
    url: '/business/securityInspectRectify/edit',
    method: 'post',
    data: data
  })
}

// 删除安全检查整改
export function delSecurityInspectRectify(id) {
  return request({
    url: '/business/securityInspectRectify/delete/' + id,
    method: 'post'
  })
}
