import request from '@/utils/request'

// 查询安全检查报告列表
export function listSecurityInspectReport(query) {
  return request({
    url: '/business/securityInspectReport/list',
    method: 'get',
    params: query
  })
}

// 查询安全检查报告详细
export function getSecurityInspectReport(id) {
  return request({
    url: '/business/securityInspectReport/' + id,
    method: 'get'
  })
}

// 新增安全检查报告
export function addSecurityInspectReport(data) {
  return request({
    url: '/business/securityInspectReport',
    method: 'post',
    data: data
  })
}

// 修改安全检查报告
export function updateSecurityInspectReport(data) {
  return request({
    url: '/business/securityInspectReport/edit',
    method: 'post',
    data: data
  })
}

// 删除安全检查报告
export function delSecurityInspectReport(id) {
  return request({
    url: '/business/securityInspectReport/delete/' + id,
    method: 'post',
    data: id
  })
}
