import request from '@/utils/request'

// 查询特种设备列表
export function listINFO(query) {
  return request({
    url: '/business/specialDeviceInfo/list',
    method: 'get',
    params: query
  })
}

// 查询特种设备详细
export function getINFO(id) {
  return request({
    url: '/business/specialDeviceInfo/' + id,
    method: 'get'
  })
}

// 新增特种设备
export function addINFO(data) {
  return request({
    url: '/business/specialDeviceInfo',
    method: 'post',
    data: data
  })
}

// 修改特种设备
export function updateINFO(data) {
  return request({
    url: '/business/specialDeviceInfo/edit',
    method: 'post',
    data: data
  })
}

// 删除特种设备
export function delINFO(id) {
  return request({
    url: '/business/specialDeviceInfo/delete/' + id,
    method: 'post'
  })
}
