import request from '@/utils/request'

// 查询特种设备年检/保养记录列表
export function listRECORD(query) {
  return request({
    url: '/business/specialDeviceKeepRecord/getList',
    method: 'get',
    params: query
  })
}

// 查询特种设备年检/保养记录详细
export function getRECORD(id) {
  return request({
    url: '/business/specialDeviceKeepRecord/' + id,
    method: 'get'
  })
}

// 新增特种设备年检/保养记录
export function addRECORD(data) {
  return request({
    url: '/business/specialDeviceKeepRecord',
    method: 'post',
    data: data
  })
}

// 修改特种设备年检/保养记录
export function updateRECORD(data) {
  return request({
    url: '/business/specialDeviceKeepRecord/edit',
    method: 'post',
    data: data
  })
}

// 删除特种设备年检/保养记录
export function delRECORD(id) {
  return request({
    url: '/business/specialDeviceKeepRecord/delete/' + id,
    method: 'post'
  })
}
