import request from '@/utils/request'

// 查询特种设备清单列表
export function listINFO(query) {
  return request({
    url: '/business/specialDeviceListInfo/getList',
    method: 'get',
    params: query
  })
}

// 查询特种设备清单详细
export function getINFO(id) {
  return request({
    url: '/business/specialDeviceListInfo/' + id,
    method: 'get'
  })
}

// 新增特种设备清单
export function addINFO(data) {
  return request({
    url: '/business/specialDeviceListInfo',
    method: 'post',
    data: data
  })
}

// 修改特种设备清单
export function updateINFO(data) {
  return request({
    url: '/business/specialDeviceListInfo/edit',
    method: 'post',
    data: data
  })
}

// 删除特种设备清单
export function delINFO(id) {
  return request({
    url: '/business/specialDeviceListInfo/delete/' + id,
    method: 'post'
  })
}
