import request from '@/utils/request'

// 查询特种作业列表
export function listSpecialWork(query) {
  return request({
    url: '/business/specialWork/list',
    method: 'get',
    params: query
  })
}

// 查询特种作业详细
export function getSpecialWork(id) {
  return request({
    url: '/business/specialWork/' + id,
    method: 'get'
  })
}

// 新增特种作业
export function addSpecialWork(data) {
  return request({
    url: '/business/specialWork',
    method: 'post',
    data: data
  })
}

// 修改特种作业
export function updateSpecialWork(data) {
  return request({
    url: '/business/specialWork/edit',
    method: 'post',
    data: data
  })
}

// 删除特种作业
export function delSpecialWork(id) {
  return request({
    url: '/business/specialWork/delete/' + id,
    method: 'post'
  })
}
