import request from '@/utils/request'

// 查询验菜人员排班列表
export function listTAmCrewRostering(query) {
  return request({
    url: '/business/tAmCrewRostering/list',
    method: 'get',
    params: query
  })
}

// 查询验菜人员排班详细
export function getTAmCrewRostering(id) {
  return request({
    url: '/business/tAmCrewRostering/' + id,
    method: 'get'
  })
}

// 新增验菜人员排班
export function addTAmCrewRostering(data) {
  return request({
    url: '/business/tAmCrewRostering',
    method: 'post',
    data: data
  })
}

// 修改验菜人员排班
export function updateTAmCrewRostering(data) {
  return request({
    url: '/business/tAmCrewRostering/edit',
    method: 'post',
    data: data
  })
}

// 删除验菜人员排班
export function delTAmCrewRostering(id) {
  return request({
    url: '/business/tAmCrewRostering/delete/' + id,
    method: 'post',
    data: id
  })
}
