import request from '@/utils/request'

// 查询员工报餐计划列表
export function listTAmEmployeeReportPlan(query) {
  return request({
    url: '/business/tAmEmployeeReportPlan/list',
    method: 'get',
    params: query
  })
}

// 查询员工报餐计划详细
export function getTAmEmployeeReportPlan(data) {
  return request({
    url: '/business/tAmEmployeeReportPlan/getDetailByInfo',
    method: 'post',
    data: data
  })
}

// 新增员工报餐计划
export function addTAmEmployeeReportPlan(data) {
  return request({
    url: '/business/tAmEmployeeReportPlan',
    method: 'post',
    data: data
  })
}

// 修改员工报餐计划
export function updateTAmEmployeeReportPlan(data) {
  return request({
    url: '/business/tAmEmployeeReportPlan/edit',
    method: 'post',
    data: data
  })
}

// 删除员工报餐计划
export function delTAmEmployeeReportPlan(id) {
  return request({
    url: '/business/tAmEmployeeReportPlan/delete/' + id,
    method: 'post'
  })
}


// 新增员工报餐计划
export function insertTAmEmployeeReportPlan(data) {
  return request({
    url: '/business/tAmEmployeeReportPlan/insertTAmEmployeeReportPlan',
    method: 'post',
    data: data
  })
}
