import request from '@/utils/request'

// 查询食堂菜谱发布列表
export function listTAmMenuRelease(query) {
  return request({
    url: '/business/tAmMenuRelease/list',
    method: 'get',
    params: query
  })
}

// 查询食堂菜谱发布列表
export function getTAmMenuReleaseListAll(query) {
  return request({
    url: '/business/tAmMenuRelease/listAll',
    method: 'get',
    params: query
  })
}

// 查询食堂菜谱发布详细
export function getTAmMenuRelease(id) {
  return request({
    url: '/business/tAmMenuRelease/' + id,
    method: 'get'
  })
}

// 新增食堂菜谱发布
export function addTAmMenuRelease(data) {
  return request({
    url: '/business/tAmMenuRelease',
    method: 'post',
    data: data
  })
}

// 修改食堂菜谱发布
export function updateTAmMenuRelease(data) {
  return request({
    url: '/business/tAmMenuRelease/edit',
    method: 'post',
    data: data
  })
}

// 删除食堂菜谱发布
export function delTAmMenuRelease(id) {
  return request({
    url: '/business/tAmMenuRelease/delete/' + id,
    method: 'post'
  })
}

// 新增食堂菜谱发布
export function insertTAmMenuReleaseAndDetail(data) {
  return request({
    url: '/business/tAmMenuRelease/insertTAmMenuReleaseAndDetail',
    method: 'post',
    data: data
  })
}

// 午餐总数
export function getCountByInfo(data) {
  return request({
    url: '/business/tAmEmployeeReportPlan/getCountByInfo',
    method: 'post',
    data: data
  })
}
