import request from '@/utils/request'

// 查询餐品留样记录列表
export function listTAmRetentionSample(query) {
  return request({
    url: '/business/tAmRetentionSample/list',
    method: 'get',
    params: query
  })
}



// 查询餐品留样记录详细
export function getTAmRetentionSample(id) {
  return request({
    url: '/business/tAmRetentionSample/' + id,
    method: 'get'
  })
}

// 新增餐品留样记录
export function addTAmRetentionSample(data) {
  return request({
    url: '/business/tAmRetentionSample',
    method: 'post',
    data: data
  })
}

// 修改餐品留样记录
export function updateTAmRetentionSample(data) {
  return request({
    url: '/business/tAmRetentionSample/edit',
    method: 'post',
    data: data
  })
}

// 删除餐品留样记录
export function delTAmRetentionSample(id) {
  return request({
    url: '/business/tAmRetentionSample/delete/' + id,
    method: 'post'
  })
}


// 新增餐品留样记录
export function insertRetentionSampleAndDetail(data) {
  return request({
    url: '/business/tAmRetentionSample/insertRetentionSampleAndDetail',
    method: 'post',
    data: data
  })
}


// 查询餐品留样记录列表
export function listAllSpecifics(query) {
  return request({
    url: '/business/TAmMenuReleaseSpecifics/listAll',
    method: 'get',
    params: query
  })
}