import request from '@/utils/request'

// 查询宿舍评比列表
export function listTAmRoomComparison(query) {
  return request({
    url: '/business/tAmRoomComparison/list',
    method: 'get',
    params: query
  })
}

// 查询宿舍记录列表
export function listAll(query) {
  return request({
    url: '/business/tAmRoomManage/listAll',
    method: 'get',
    params: query
  })
}

// 查询宿舍评比详细
export function getTAmRoomComparison(id) {
  return request({
    url: '/business/tAmRoomComparison/' + id,
    method: 'get'
  })
}

// 新增宿舍评比
export function addTAmRoomComparison(data) {
  return request({
    url: '/business/tAmRoomComparison',
    method: 'post',
    data: data
  })
}

// 修改宿舍评比
export function updateTAmRoomComparison(data) {
  return request({
    url: '/business/tAmRoomComparison/edit',
    method: 'post',
    data: data
  })
}

// 删除宿舍评比
export function delTAmRoomComparison(id) {
  return request({
    url: '/business/tAmRoomComparison/delete/' + id,
    method: 'post'
  })
}

// 新增宿舍评比
export function insertTAmRoomComparisonAndDetail(data) {
  return request({
    url: '/business/tAmRoomComparison/insertTAmRoomComparisonAndDetail',
    method: 'post',
    data: data
  })
}


// 查询宿舍记录列表
export function listHistory(id) {
  return request({
    url: '/business/tAmRoomTerm/listHistory/' + id,
    method: 'get'
  })
}