import request from '@/utils/request'

// 查询 宿舍档案管理列表
export function listTAmRoomManage(query) {
  return request({
    url: '/business/tAmRoomManage/list',
    method: 'get',
    params: query
  })
}

// 查询 宿舍档案管理详细
export function getTAmRoomManage(id) {
  return request({
    url: '/business/tAmRoomManage/' + id,
    method: 'get'
  })
}

// 新增 宿舍档案管理
export function addTAmRoomManage(data) {
  return request({
    url: '/business/tAmRoomManage',
    method: 'post',
    data: data
  })
}

// 修改 宿舍档案管理
export function updateTAmRoomManage(data) {
  return request({
    url: '/business/tAmRoomManage/edit',
    method: 'post',
    data: data
  })
}

// 删除 宿舍档案管理
export function delTAmRoomManage(id) {
  return request({
    url: '/business/tAmRoomManage/delete/' + id,
    method: 'post'
  })
}

// 新增 宿舍档案管理
export function insertTAmRoomManageAndDetail(data) {
  return request({
    url: '/business/tAmRoomManage/insertTAmRoomManageAndDetail',
    method: 'post',
    data: data
  })
}

