import request from '@/utils/request'

// 查询宿舍评比项列表
export function listTAmRoomTerm(query) {
  return request({
    url: '/business/tAmRoomTerm/list',
    method: 'get',
    params: query
  })
}

// 查询宿舍评比项详细
export function getTAmRoomTerm(id) {
  return request({
    url: '/business/tAmRoomTerm/' + id,
    method: 'get'
  })
}

// 新增宿舍评比项
export function addTAmRoomTerm(data) {
  return request({
    url: '/business/tAmRoomTerm',
    method: 'post',
    data: data
  })
}

// 修改宿舍评比项
export function updateTAmRoomTerm(data) {
  return request({
    url: '/business/tAmRoomTerm/edit',
    method: 'post',
    data: data
  })
}

// 删除宿舍评比项
export function delTAmRoomTerm(id) {
  return request({
    url: '/business/tAmRoomTerm/delete',
    method: 'post',
    data: id
  })
}
