import request from '@/utils/request'

// 查询水电管理明细列表
export function listTAmWaterElectric(query) {
  return request({
    url: '/business/tAmWaterElectric/list',
    method: 'get',
    params: query
  })
}

// 查询水电管理明细详细
export function getTAmWaterElectric(id) {
  return request({
    url: '/business/tAmWaterElectric/' + id,
    method: 'get'
  })
}

// 新增水电管理明细
export function addTAmWaterElectric(data) {
  return request({
    url: '/business/tAmWaterElectric',
    method: 'post',
    data: data
  })
}

// 修改水电管理明细
export function updateTAmWaterElectric(data) {
  return request({
    url: '/business/tAmWaterElectric/edit',
    method: 'post',
    data: data
  })
}

// 删除水电管理明细
export function delTAmWaterElectric(id) {
  return request({
    url: '/business/tAmWaterElectric/delete/' + id,
    method: 'post'
  })
}


// 新增水电管理明细
export function insertTAmWaterElectricList(data) {
  return request({
    url: '/business/tAmWaterElectric/insertTAmWaterElectricList',
    method: 'post',
    data: data
  })
}