import request from '@/utils/request'

// 查询表头管理列表
export function listINFO(query) {
  return request({
    url: '/business/INFO/list',
    method: 'get',
    params: query
  })
}

// 查询表头管理详细
export function getINFO(id) {
  return request({
    url: '/business/INFO/' + id,
    method: 'get'
  })
}

// 新增表头管理
export function addINFO(data) {
  return request({
    url: '/business/INFO',
    method: 'post',
    data: data
  })
}

// 修改表头管理
export function updateINFO(data) {
  return request({
    url: '/business/INFO/edit',
    method: 'post',
    data: data
  })
}

// 删除表头管理
export function delINFO(id) {
  return request({
    url: '/business/INFO/delete/' + id,
    method: 'post'
  })
}
