import request from '@/utils/request'

// 查询检查记录列表
export function listRecord(query) {
  return request({
    url: '/business/tchecktablerecord/list',
    method: 'get',
    params: query
  })
}

// 查询检查记录详细
export function getRecord(id) {
  return request({
    url: '/business/tchecktablerecord/' + id,
    method: 'get'
  })
}

// 新增检查记录
export function addRecord(data) {
  return request({
    url: '/business/tchecktablerecord',
    method: 'post',
    data: data
  })
}

// 修改检查记录
export function updateRecord(data) {
  return request({
    url: '/business/tchecktablerecord',
    method: 'put',
    data: data
  })
}

// 删除检查记录
export function delRecord(id) {
  return request({
    url: '/business/tchecktablerecord/' + id,
    method: 'delete'
  })
}
