/**
 * boss-首页
 */
import request from '@/utils/request'

/**
 * @function getPendingFlowGroup
 * @description 待审批页面分组数据
 */
export function getPendingFlowGroup() {
  return request({
    url: '/flowEngine/boss/getPendingFlowGroup',
    method: 'get'
  })
}

/**
 * @function getApprovedFlowGroup
 * @description 已审批页面分组数据
 * @param {object} params
 * @param {string} params.startDate 开始日期(非必填)
 * @param {string} params.endDate 结束日期(非必填)
 */
export function getApprovedFlowGroup(params) {
  return request({
    url: '/flowEngine/boss/getApprovedFlowGroup',
    method: 'get',
    params
  })
}

/**
 * @function getReturnFlowGroup
 * @description 已退回页面分组数据
 * @param {object} params
 * @param {string} params.pageNum 页数
 * @param {string} params.pageSize 数/页
 * @param {string} params.startDate 开始日期(非必填)
 * @param {string} params.endDate 结束日期(非必填)
 */
export function getReturnFlowGroup(params) {
  return request({
    url: '/flowEngine/boss/getReturnFlowGroup',
    method: 'get',
    params
  })
}

/**
 * @function getPendingFlowList
 * @description 待审批列表
 * @param {object} params
 * @param {string} params.pageNum 页数
 * @param {string} params.pageSize 数/页
 * @param {string} params.companyId 公司id
 * @param {string} params.processGroup 流程分组id(审批类型)
 */
export function getPendingFlowList(params) {
  return request({
    url: '/flowEngine/boss/getPendingFlowList',
    method: 'get',
    params
  })
}

/**
 * @function getApprovedFlowList
 * @description 已审批列表
 * @param {object} params
 * @param {string} params.pageNum 页数
 * @param {string} params.pageSize 数/页
 * @param {string} params.companyId 公司id 非必填
 * @param {string} params.processGroup 流程分组id(审批类型) 非必填
 * @param {string} params.startDate 开始日期(非必填)
 * @param {string} params.endDate 结束日期(非必填)
 */
export function getApprovedFlowList(params) {
  return request({
    url: '/flowEngine/boss/getApprovedFlowList',
    method: 'get',
    params
  })
}

/**
 * @function getReturnFlowList
 * @description 已退回列表
 * @param {object} params
 * @param {string} params.pageNum 页数
 * @param {string} params.pageSize 数/页
 * @param {string} params.companyId 公司id 非必填
 * @param {string} params.processGroup 流程分组id(审批类型) 非必填
 * @param {string} params.startDate 开始日期(非必填)
 * @param {string} params.endDate 结束日期(非必填)
 */
export function getReturnFlowList(params) {
  return request({
    url: '/flowEngine/boss/getReturnFlowList',
    method: 'get',
    params
  })
}
