/*
 * @Description: 流程定义js,包括列表查询、详细查询、定义编辑、定义删除、定义部署
 * @Author: jinhao
 * @Date: 2022-06-14
 */
import request from '@/utils/request'
const serverUrl = '/flowEngine'

// 查询部署列表
export function defTablelist(data) {
  return request({
    url: `${serverUrl}/flowDefController/selectDefPageList`,
    method: 'get',
    params: data
  })
}
// 部署保存或编辑
export function saveDefProcess(data) {
  return request({
    url: `${serverUrl}/flowDefController/saveOrUpdateDefProcess`,
    method: 'post',
    data
  })
}
// 复制流程定义
export function copyDefProcess(data) {
  return request({
    url: `${serverUrl}/flowDefController/copyDefProcess`,
    method: 'post',
    data
  })
}


// 流程定义查询详细数据
export function selectDefProcessDetail(params) {
  return request({
    url: `${serverUrl}/flowDefController/selectDefProcessDetail`,
    method: 'get',
    params
  })
}

// 部署流程
export function deployFlow(data) {
  return request({
    url: `${serverUrl}/flowDefController/defProcessDeploy`,
    method: 'post',
    data
  })
}
// 流程定义模版删除
export function removeProcess(id) {
  return request({
    url: `${serverUrl}/flowDefController/delProcessDefById`,
    method: 'get',
    params: { id: id }
  })
}

// 获取角色、部门
export function selectUserTypeData(data = {}) {
  return request({
    url: `${serverUrl}/flowAssignApprovaController/selectUserTypeData`,
    method: 'post',
    data
  })
}

/**
 * 获取审核人
 * @param {String} orgId 部门id
 * @returns {Promise}
 */
export function selectOrgNextUserData({ orgId = '' } = {}) {
  return request({
    url: `${serverUrl}/flowAssignApprovaController/selectOrgNextUserData`,
    method: 'post',
    params: {
      orgId
    }
  })
}