/**
 * 流程引擎单独字典js
 */
import request from '@/utils/request'
const serverUrl = '/flowEngine'

// 查询流程字典方法，通用，例如传{dictCode: 'PROCESS_GROUP'}，返回list
export function selectDictList(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/selectDictList`,
    method: 'post',
    data
  })
}

// 查询流程字典列表
export function selectFlowDictTableList(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/selectFlowDictTableList`,
    method: 'get',
    params: data
  })
}

// 查询item字典列表
export function selectDictItemTableList(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/selectDictItemTableList`,
    method: 'post',
    data
  })
}

// 保存/修改字典item数据
export function addDictBizItem(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/saveOrUpdateItem`,
    method: 'post',
    data
  })
}

// 启用/禁用字典数据
export function disableItemData(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/disableItemData`,
    method: 'post',
    data
  })
}
// 删除字典
export function deleteDictItem(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/deleteDictItem`,
    method: 'post',
    data
  })
}


// 查询字典数据详细ByID
export function getDictItemDetailById(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/getDictItemDetailById`,
    method: 'post',
    data
  })
}

// 查询事件上报的部署流程
export function selectEventFlowDeployList(data) {
  return request({
    url: `${serverUrl}/flowDictBizController/selectEventFlowDeployList`,
    method: 'post',
    data
  })
}
