
/**
 * 代签管理
 */
import request from '@/utils/request'
const serverUrl = '/flowEngine'

/**
 * 查询代签人管理列表
 * @param {any} query 查询参数
 */
export function listSign(query) {
  return request({
    url: `${serverUrl}/agentSign/pageList`,
    method: 'get',
    params: query
  })
}

// 查询代签人管理详细
export function getSign(id) {
  return request({
    url: `${serverUrl}/agentSign/getDetail`,
    method: 'get',
    params: { id: id }
  })
}

// 新增代签人管理
export function addSign(data) {
  return request({
    url: `${serverUrl}/agentSign/add`,
    method: 'post',
    data: data
  })
}

// 修改代签人管理
export function updateSign(data) {
  return request({
    url: `${serverUrl}/agentSign/edit`,
    method: 'post',
    data: data
  })
}

// 删除代签人管理
export function delSign(id) {
  return request({
    url: `${serverUrl}/agentSign/deleteBatch`,
    method: 'get',
    params: { ids: id }
  })
}
/**
 * 查询组织人员树
 */
export function treeselect() {
  return request({
    url: `${serverUrl}/agentSign/viewDeptAll`,
    method: 'get'
  })
}
