
/**
 * 流程引擎相关方法接口
 */
import request from '@/utils/request'
const serverUrl = '/flowEngine'

// 启动流程
export function startFlow(data) {
  return request({
    url: `${serverUrl}/flowApiController/startFlow`,
    method: 'post',
    data
  })
}
// 待办任务列表
export function getTodoList(data) {
  return request({
    url: `${serverUrl}/flowApiController/getTodoList`,
    method: 'post',
    data
  })
}
// 已办任务列表
export function getDoneList(query) {
  return request({
    url: `${serverUrl}/flowApiController/getDoneList`,
    method: 'get',
    params: query
  })
}
// 已发起列表
export function querySendList(data) {
  return request({
    url: `${serverUrl}/flowApiController/querySendList`,
    method: 'post',
    data
  })
}
// 抄送列表
export function queryChaoSongList(query) {
  return request({
    url: `${serverUrl}/flowApiController/queryChaoSongList`,
    method: 'get',
    params: query
  })
}
// 审批通过
export function handlePass(data) {
  return request({
    url: `${serverUrl}/flowApiController/completeTask`,
    method: 'post',
    data
  })
}
// 审批拒绝
export function refuseFlow(data) {
  return request({
    url: `${serverUrl}/flowApiController/refuseFlow`,
    method: 'post',
    data
  })
}
// 终止流程
export function stopFlow(data) {
  return request({
    url: `${serverUrl}/flowApiController/stopFlow`,
    method: 'post',
    data
  })
}
// 流程重新发起
export function restartFlow(data) {
  return request({
    url: `${serverUrl}/flowApiController/restartFlow`,
    method: 'post',
    data
  })
}

// 查看审批历程
export function getApprovalProcess(data) {
  return request({
    url: `${serverUrl}/flowApiController/getApprovalProcess`,
    method: 'post',
    data
  })
}
// 退回节点列表
export function getReturnNodeList(data) {
  return request({
    url: `${serverUrl}/flowApiController/getReturnNodeList`,
    method: 'post',
    data
  })
}
// 任务退回
export function goBack(data) {
  return request({
    url: `${serverUrl}/flowApiController/goBack`,
    method: 'post',
    data
  })
}

// 加签审批
export function addUser(data) {
  return request({
    url: `${serverUrl}/flowApiController/addUser`,
    method: 'post',
    data
  })
}
// 任务转派
export function turnTask(data) {
  return request({
    url: `${serverUrl}/flowApiController/turnTask`,
    method: 'post',
    data
  })
}

// 任务撤回
export function revokeTask(data) {
  return request({
    url: `${serverUrl}/flowApiController/revokeProcess`,
    method: 'post',
    data
  })
}

/**
 * 查看流程图(已启动的流程实例)
 * @param {string} instanceId 实例id
 * @returns
 */
export function getFlowChart(data) {
  return request({
    url: `${serverUrl}/flowApiController/getFlowChart`,
    method: 'post',
    data
  })
}
// 查看流程图(流程定义或者流程部署)
export function getFlowChartDefp(data) {
  return request({
    url: `${serverUrl}/flowDefController/getFlowChartDefp`,
    method: 'post',
    data
  })
}

// 查看运行流程节点下一节点 是否自定义选择用户审批
export function selectCurrentNodeNextNodeUserType(data) {
  return request({
    url: `${serverUrl}/flowApiController/selectNextNodeUserType`,
    method: 'post',
    data
  })
}

// 启动获取流程定义节点 是否存在自选节点
export function getBeginNodeNextHandleWay(data) {
  return request({
    url: `${serverUrl}/flowApiController/getBeginNodeNextHandleWay`,
    method: 'post',
    data
  })
}