import request from '@/utils/request'

// 查询绩效考核方案管理列表
export function listAccessPlan(query) {
  return request({
    url: '/kpi/accessPlan/list',
    method: 'get',
    params: query
  })
}

// 查询绩效考核方案管理详细
export function getAccessPlan(id) {
  return request({
    url: '/kpi/accessPlan/' + id,
    method: 'get'
  })
}

// 新增绩效考核方案管理
export function addAccessPlan(data) {
  return request({
    url: '/kpi/accessPlan',
    method: 'post',
    data: data
  })
}

// 修改绩效考核方案管理
export function updateAccessPlan(data) {
  return request({
    url: '/kpi/accessPlan/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效考核方案管理
export function delAccessPlan(id) {
  return request({
    url: '/kpi/accessPlan/delete',
    method: 'post',
    data: id
  })
}

export function enabledPlanStatus(data) {
  return request({
    url: '/kpi/accessPlan/enabledPlanStatus',
    method: 'post',
    data: data
  })
}
