import request from '@/utils/request'

// 查询绩效考核管理列表
export function listAssess(query) {
  return request({
    url: '/kpi/assess/list',
    method: 'get',
    params: query
  })
}

// 查询绩效考核管理详细
export function getAssess(id) {
  return request({
    url: '/kpi/assess/' + id,
    method: 'get'
  })
}

// 新增绩效考核管理
export function addAssess(data) {
  return request({
    url: '/kpi/assess',
    method: 'post',
    data: data
  })
}

// 修改绩效考核管理
export function updateAssess(data) {
  return request({
    url: '/kpi/assess/edit',
    method: 'post',
    data: data
  })
}

export function updateJxAssessTable(data) {
  return request({
    url: '/kpi/assess/updateJxAssessTable',
    method: 'post',
    data: data
  })
}

// 删除绩效考核管理
export function delAssess(id) {
  return request({
    url: '/kpi/assess/delete',
    method: 'post',
    data: id
  })
}


// 查询符合条件的员工列表
export function userList(query) {
  return request({
    url: '/kpi/assess/userList',
    method: 'get',
    params: query
  })
}

// 提交考核审定
export function reviewAssess(data) {
  return request({
    url: '/kpi/assess/reviewAssess',
    method: 'post',
    data: data
  })
}

export function recalculateAssess(data) {
  return request({
    url: '/kpi/assess/recalculateAssess',
    method: 'post',
    data: data
  })
}

export function getPenetratingData(data) {
  return request({
    url: '/kpi/assess/getPenetratingData',
    method: 'post',
    data: data
  })
}


export function updateAuditStatus(data) {
  return request({
    url: '/kpi/assess/updateAuditStatus',
    method: 'post',
    data: data
  })
}

export function startAudit(data) {
  return request({
    url: '/kpi/assess/startAudit',
    method: 'post',
    data: data
  })
}
