import request from '@/utils/request'

// 查询绩效考核方案 - 考核指标列表
export function listAssessPLanIndicator(query) {
  return request({
    url: '/kpi/assessPLanIndicator/list',
    method: 'get',
    params: query
  })
}

// 查询绩效考核方案 - 考核指标详细
export function getAssessPLanIndicator(id) {
  return request({
    url: '/kpi/assessPLanIndicator/' + id,
    method: 'get'
  })
}

// 新增绩效考核方案 - 考核指标
export function addAssessPLanIndicator(data) {
  return request({
    url: '/kpi/assessPLanIndicator',
    method: 'post',
    data: data
  })
}

// 修改绩效考核方案 - 考核指标
export function updateAssessPLanIndicator(data) {
  return request({
    url: '/kpi/assessPLanIndicator/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效考核方案 - 考核指标
export function delAssessPLanIndicator(id) {
  return request({
    url: '/kpi/assessPLanIndicator/delete',
    method: 'post',
    data: id
  })
}
